/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.neoauth.mixin;

import com.mrbysco.neoauth.NeoAuth;
import com.mrbysco.neoauth.impl.gui.AuthMethodScreen;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.DisconnectedScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.DisconnectionDetails;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={DisconnectedScreen.class})
public abstract class DisconnectedScreenMixin
extends Screen {
    @Shadow
    @Final
    private Screen parent;
    @Shadow
    @Final
    private DisconnectionDetails details;

    private DisconnectedScreenMixin(Component title) {
        super(title);
    }

    @Inject(method={"init"}, at={@At(value="TAIL")})
    private void init(CallbackInfo ci) {
        if (DisconnectedScreenMixin.isUserRelated(this.details.reason())) {
            NeoAuth.LOGGER.info("Adding auth button to the disconnected screen");
            assert (this.minecraft != null);
            Button backButton = (Button)this.children().get(2);
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.neo_auth.button.relogin"), btn -> this.minecraft.setScreen((Screen)new AuthMethodScreen(this.parent))).bounds(backButton.getX(), backButton.getY(), backButton.getWidth(), backButton.getHeight()).build());
            backButton.setY(backButton.getY() + backButton.getHeight() + 4);
        }
    }

    @Unique
    private static boolean isUserRelated(@Nullable Component reason) {
        block20: {
            boolean bl;
            block22: {
                block21: {
                    ComponentContents componentContents;
                    if (reason == null || !((componentContents = reason.getContents()) instanceof TranslatableContents)) break block20;
                    TranslatableContents content = (TranslatableContents)componentContents;
                    String key = content.getKey();
                    if (key == null) break block21;
                    switch (key) {
                        case "disconnect.kicked": 
                        case "multiplayer.disconnect.banned": 
                        case "multiplayer.disconnect.banned.reason": 
                        case "multiplayer.disconnect.banned.expiration": 
                        case "multiplayer.disconnect.duplicate_login": 
                        case "multiplayer.disconnect.kicked": 
                        case "multiplayer.disconnect.unverified_username": 
                        case "multiplayer.disconnect.not_whitelisted": 
                        case "multiplayer.disconnect.name_taken": 
                        case "multiplayer.disconnect.missing_public_key": 
                        case "multiplayer.disconnect.expired_public_key": 
                        case "multiplayer.disconnect.invalid_public_key_signature": 
                        case "multiplayer.disconnect.unsigned_chat": 
                        case "multiplayer.disconnect.chat_validation_failed": {
                            break;
                        }
                        default: {
                            if (key.startsWith("disconnect.loginFailed")) {
                                break;
                            }
                            break block21;
                        }
                    }
                    bl = true;
                    break block22;
                }
                bl = false;
            }
            return bl;
        }
        return false;
    }
}

